
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Payment Request</title>

    <!-- Bootstrap 4 CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<style>
    .copy-btn {
        cursor: pointer;
    }
</style>

<body>

    <div class="container mt-5">
        <div class="form-group">
            <label for="apiKey">API Key</label>
            <input type="text" class="form-control" id="apiKey" placeholder="Enter your API key" value="xnd_development_G4tIKqLCksPXm2YwdHy4p5xzRUHKEyyBBIlmGAN71jxZz79vYSlRMbleUqeWq">
        </div>
        <div id="bank-data-accordion">
            <div class="card">
                <div class="card-header" id="bank-data-header">
                    <h5 class="mb-0">
                        <button class="btn btn-link" data-toggle="collapse" data-target="#bank-data-body" aria-expanded="true" aria-controls="bank-data-body">
                            Bank List (Click to expand/collapse)
                        </button>
                    </h5>
                </div>

                <div id="bank-data-body" class="collapse hide" aria-labelledby="bank-data-header" data-parent="#bank-data-accordion">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>Bank Name</th>
                                        <th>Code</th>
                                        <th>Country</th>
                                        <th>Currency</th>
                                        <th>Is Activated</th>
                                        <th>Copy Code</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    // Load the JSON data from bank_data.json
                                    $json_file = 'bank_data.json';
                                    if (file_exists($json_file)) {
                                        $json_data = file_get_contents($json_file);
                                        $banks = json_decode($json_data, true);

                                        // Loop through the bank data and display it in table rows
                                        foreach ($banks as $bank) {
                                            echo '<tr>';
                                            echo '<td>' . htmlspecialchars($bank['name']) . '</td>';
                                            echo '<td class="bank-code">' . htmlspecialchars($bank['code']) . '</td>';
                                            echo '<td>' . htmlspecialchars($bank['country']) . '</td>';
                                            echo '<td>' . htmlspecialchars($bank['currency']) . '</td>';
                                            echo '<td>' . ($bank['is_activated'] ? 'Yes' : 'No') . '</td>';
                                            echo '<td><button class="btn btn-primary copy-btn" data-code="' . htmlspecialchars($bank['code']) . '">Copy Code</button></td>';
                                            echo '</tr>';
                                        }
                                    } else {
                                        echo '<tr><td colspan="6" class="text-center">No data available</td></tr>';
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <br>
        <!-- Button to trigger modal -->
        <button type="button" class="btn btn-block btn-primary" data-toggle="modal" data-target="#paymentModal">
            Create Payment
        </button>
        <br>
        <div id="saved-responses-accordion" class="mt-4">
            <div class="card">
                <div class="card-header" id="saved-responses-header">
                    <h5 class="mb-0">
                        <button class="btn btn-link" data-toggle="collapse" data-target="#saved-responses-body" aria-expanded="true" aria-controls="saved-responses-body">
                            Saved Responses (Click to expand/collapse)
                        </button>
                    </h5>
                </div>

                <div id="saved-responses-body" class="collapse show" aria-labelledby="saved-responses-header" data-parent="#saved-responses-accordion">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>Payment Method ID</th>
                                        <th>Channel Code</th>
                                        <th>Customer Name</th>
                                        <th>Virtual Account Number</th>
                                        <th>Expires At</th>
                                        <th>Timestamp</th>
                                        <th>Copy VA Number</th>
                                    </tr>
                                </thead>
                                <tbody id="saved-responses-table-body">
                                    <!-- Table rows will be populated dynamically -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Modal -->
        <div class="modal fade" id="paymentModal" tabindex="-1" role="dialog" aria-labelledby="paymentModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="paymentModalLabel">Create Payment Request</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form id="paymentForm" method="POST">
                        <div class="modal-body">
                            <!-- Amount Input -->
                            <div class="form-group">
                                <label for="amount" >Amount (IDR)</label>
                                <input type="number" class="form-control" id="amount" name="amount" placeholder="Leave blank to Open Amount">
                            </div>

                            <!-- Customer Name Input -->
                            <div class="form-group">
                                <label for="customerName">Customer Name</label>
                                <input type="text" class="form-control" id="customerName" name="customer_name" required>
                            </div>

                            <!-- Bank Channel Code Selection -->
                            <div class="form-group">
                                <label for="channelCode">Bank Channel</label>
                                <select class="form-control" id="channelCode" name="channel_code" required>
                                    <option value="" selected disabled>Select Bank</option>
                                    <?php
                                    // Load the JSON data from bank_data.json
                                    $json_file = 'bank_data.json';
                                    if (file_exists($json_file)) {
                                        $json_data = file_get_contents($json_file);
                                        $banks = json_decode($json_data, true);

                                        // Populate the dropdown options with bank codes from bank_data.json
                                        foreach ($banks as $bank) {
                                            if ($bank['is_activated']) {
                                                echo '<option value="' . htmlspecialchars($bank['code']) . '">' . htmlspecialchars($bank['name']) . ' (' . htmlspecialchars($bank['code']) . ')</option>';
                                            }
                                        }
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Submit Payment</button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Result Display -->
        <!--<div class="mt-4">-->
        <!--    <h5>Response:</h5>-->
        <!--    <pre id="responseOutput"></pre>-->
        <!--</div>-->
    </div>

    <!-- Bootstrap 4 JS, Popper.js, and jQuery -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script>
        $(document).ready(function() {
            // Load saved responses when the page loads
            loadSavedResponses();

            // Handle form submission
            $('#paymentForm').on('submit', function(e) {
                e.preventDefault();

                // Get API key
                const apiKey = $('#apiKey').val();
                if (!apiKey) {
                    alert('Please enter an API key');
                    return;
                }

                // Get form values
                const amount = $('#amount').val();
                const customerName = $('#customerName').val();
                const channelCode = $('#channelCode').val();

                // Prepare the request body for the API
                const requestBody = {
                    apiKey: apiKey,
                    currency: "IDR",
                    amount: parseInt(amount),
                    payment_method: {
                        type: "VIRTUAL_ACCOUNT",
                        reusability: "MULTIPLE_USE",
                        reference_id: "pm-level-" + Date.now(), // Unique reference ID
                        virtual_account: {
                            channel_code: channelCode,
                            channel_properties: {
                                customer_name: customerName
                            }
                        }
                    }
                };

                // Make the POST request using AJAX
                $.ajax({
                    url: 'submit_payment.php',
                    type: 'POST',
                    data: JSON.stringify(requestBody),
                    contentType: 'application/json',
                    success: function(response) {
                        $('#responseOutput').html(JSON.stringify(response, null, 4));

                        if (response.status === 201) {
                            alert('Payment request created successfully and saved to file!');
                            loadSavedResponses();
                            window.location.href = 'index.php';
                            exit();// Reload the saved responses table
                        } else {
                            alert('Error creating payment request. Status code: ' + response.status);
                        }
                    },
                    error: function(xhr, status, error) {
                        $('#responseOutput').html('Error: ' + error);
                        alert('Error creating payment request: ' + error);
                    }
                });
            });

            // Function to load saved responses
            function loadSavedResponses() {
                $.ajax({
                    url: 'all_responses.json',
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        const tableBody = $('#saved-responses-table-body');
                        tableBody.empty();

                        data.forEach(function(item) {
                            const row = `
                                <tr>
                                    <td>${item.payment_method.id}</td>
                                    <td>${item.payment_method.virtual_account.channel_code}</td>
                                    <td>${item.payment_method.virtual_account.channel_properties.customer_name}</td>
                                    <td class="va-number">${item.payment_method.virtual_account.channel_properties.virtual_account_number}</td>
                                    <td>${item.payment_method.virtual_account.channel_properties.expires_at}</td>
                                    <td>${item.timestamp}</td>
                                    <td><button class="btn btn-primary copy-va-btn">Copy VA</button></td>
                                </tr>
                            `;
                            tableBody.append(row);
                        });
                    },
                    error: function(xhr, status, error) {
                        console.error('Error loading saved responses:', error);
                    }
                });
            }

            // Handle copy VA number button click
            $(document).on('click', '.copy-va-btn', function() {
                const vaNumber = $(this).closest('tr').find('.va-number').text();
                navigator.clipboard.writeText(vaNumber).then(function() {
                    alert('Virtual Account number copied to clipboard!');
                }, function(err) {
                    console.error('Could not copy text: ', err);
                });
            });
        });
    </script>

</body>

</html>